<?php
// Ścieżka: public_html/trasy/get_order.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');

$configPath = __DIR__ . '/../../private/config.php';
if (file_exists($configPath)) { $config = require $configPath; } 
else { http_response_code(500); exit; }

$input = json_decode(file_get_contents('php://input'), true);
$nrZamowienia = $input['nr_zamowienia'] ?? '';
$user = $input['user'] ?? '';
$pass = $input['pass'] ?? '';

// 1. Autoryzacja (żeby nikt obcy nie podglądał)
if (empty($user) || empty($pass) || !isset($config['kierowcy'][$user]) || $config['kierowcy'][$user] !== $pass) {
    http_response_code(401); echo json_encode(['error' => 'Brak dostępu']); exit;
}

// 2. Pobranie danych z bazy
try {
    $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
    $pdo = new PDO($dsn, $config['db_user'], $config['db_pass'], [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

    $stmt = $pdo->prepare("SELECT komentarz_kierowcy, podpis_base64, sciezki_zdjec FROM potwierdzenia_dostaw WHERE numer_zamowienia = :nr");
    $stmt->execute([':nr' => $nrZamowienia]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        // Odszyfrowanie podpisu (funkcja lokalna)
        $podpisImg = '';
        if (!empty($row['podpis_base64'])) {
            $dane = base64_decode($row['podpis_base64']);
            $ivLength = openssl_cipher_iv_length("AES-256-CBC");
            if (strlen($dane) >= $ivLength) {
                $iv = substr($dane, 0, $ivLength);
                $encrypted = substr($dane, $ivLength);
                $podpisImg = openssl_decrypt($encrypted, "AES-256-CBC", $config['encryption_key'], 0, $iv);
            }
        }

        echo json_encode([
            'found' => true,
            'komentarz' => $row['komentarz_kierowcy'],
            'podpis' => $podpisImg, // Zwracamy obrazek base64
            'zdjecia' => json_decode($row['sciezki_zdjec'], true) ?? []
        ]);
    } else {
        echo json_encode(['found' => false]);
    }

} catch (PDOException $e) {
    http_response_code(500); echo json_encode(['error' => $e->getMessage()]);
}
?>