<?php
// Ścieżka: public_html/trasy/upload.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');

function loguj($msg) {
    $date = date('Y-m-d H:i:s');
    file_put_contents('log_bledow.txt', "[$date] $msg" . PHP_EOL, FILE_APPEND);
}

$configPath = __DIR__ . '/../../private/config.php';
if (file_exists($configPath)) { $config = require $configPath; } 
else { http_response_code(500); echo json_encode(['error' => 'Brak config']); exit; }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') exit;

function zaszyfruj($tekst, $key) {
    if (empty($tekst)) return null;
    $ivLength = openssl_cipher_iv_length("AES-256-CBC");
    $iv = openssl_random_pseudo_bytes($ivLength);
    $encrypted = openssl_encrypt($tekst, "AES-256-CBC", $key, 0, $iv);
    return base64_encode($iv . $encrypted);
}

try {
    $nrZamowienia = $_POST['nr_zamowienia'] ?? '';
    $user = $_POST['user'] ?? 'KIEROWCA';
    $nazwaTrasy = $_POST['nazwa_trasy'] ?? '';
    $komentarz = $_POST['komentarz'] ?? ''; 
    $dataRaw = $_POST['data'] ?? date('Y-m-d H:i:s');
    $dataDostawy = date('Y-m-d H:i:s', strtotime($dataRaw));

    if (empty($nrZamowienia)) throw new Exception('Brak numeru zamówienia');

    $nrSafe = preg_replace('/[^a-zA-Z0-9_-]/', '', $nrZamowienia);
    $dataFolder = date('Y-m-d');
    $baseUploadDir = __DIR__ . '/../../secure_uploads'; 
    $targetDir = "$baseUploadDir/$dataFolder/$nrSafe";
    $dbPathPrefix = "$dataFolder/$nrSafe";

    $maZdjecia = false;
    foreach ($_FILES as $k => $v) { if (strpos($k, 'foto_') === 0) $maZdjecia = true; }

    if ($maZdjecia && !file_exists($targetDir)) {
        mkdir($targetDir, 0777, true);
    }

    // --- PODPIS ---
    $podpisEncrypted = null;
    if (isset($_FILES['podpis']) && $_FILES['podpis']['error'] === UPLOAD_ERR_OK) {
        $binaryData = file_get_contents($_FILES['podpis']['tmp_name']);
        if ($binaryData !== false) {
            $base64 = base64_encode($binaryData);
            $fullString = 'data:image/png;base64,' . $base64;
            $podpisEncrypted = zaszyfruj($fullString, $config['encryption_key']);
        }
    }

    // --- ZDJĘCIA (NOWA LOGIKA: ZAPAMIĘTUJEMY PRODUKT ID) ---
    $noweZdjecia = [];
    foreach ($_FILES as $key => $file) {
        // Klucz przychodzi teraz jako: foto_prod_{INDEX_PRODUKTU}_{INDEX_ZDJECIA}
        // Np. foto_prod_0_1 (pierwszy produkt, drugie zdjęcie)
        if (strpos($key, 'foto_prod_') === 0 && $file['error'] === UPLOAD_ERR_OK) {
            
            // Wyciągamy index produktu z nazwy pola formularza
            // Format: foto_prod_PID_IDX
            $parts = explode('_', $key);
            $prodIndex = isset($parts[2]) ? (int)$parts[2] : 0; // Domyślnie 0 jak nie znajdzie

            $ext = pathinfo($file['name'], PATHINFO_EXTENSION) ?: 'jpg';
            $fileName = $key . '_' . time() . '.' . $ext;
            
            if (move_uploaded_file($file['tmp_name'], "$targetDir/$fileName")) {
                // ZAPISUJEMY OBIEKT: ŚCIEŻKA + ID PRODUKTU
                $noweZdjecia[] = [
                    'url' => "$dbPathPrefix/$fileName",
                    'pid' => $prodIndex
                ];
            } else {
                loguj("Błąd zapisu pliku: $fileName");
            }
        }
    }

    $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
    $pdo = new PDO($dsn, $config['db_user'], $config['db_pass'], [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

    $stmtSelect = $pdo->prepare("SELECT sciezki_zdjec FROM potwierdzenia_dostaw WHERE numer_zamowienia = :nr");
    $stmtSelect->execute([':nr' => $nrZamowienia]);
    $existingRow = $stmtSelect->fetch(PDO::FETCH_ASSOC);

    $finalPaths = $noweZdjecia;
    if ($existingRow && !empty($existingRow['sciezki_zdjec'])) {
        $oldPaths = json_decode($existingRow['sciezki_zdjec'], true);
        if (is_array($oldPaths)) {
            // Kompatybilność wsteczna: jeśli stare zdjęcia są zwykłymi stringami, zamień je na obiekty z pid=0
            foreach($oldPaths as &$op) {
                if (is_string($op)) $op = ['url' => $op, 'pid' => 0];
            }
            $finalPaths = array_merge($oldPaths, $noweZdjecia);
        }
    }

    $sql = "INSERT INTO `potwierdzenia_dostaw` 
            (numer_zamowienia, kierowca, nazwa_trasy, data_dostawy, status, komentarz_kierowcy, podpis_base64, sciezki_zdjec) 
            VALUES 
            (:nr, :user, :trasa, :data, 'DOSTARCZONE', :komentarz, :podpis, :zdjecia)
            ON DUPLICATE KEY UPDATE 
                data_dostawy = VALUES(data_dostawy),
                kierowca = VALUES(kierowca),
                nazwa_trasy = VALUES(nazwa_trasy),
                komentarz_kierowcy = VALUES(komentarz_kierowcy), 
                sciezki_zdjec = VALUES(sciezki_zdjec),
                podpis_base64 = IF(VALUES(podpis_base64) IS NOT NULL, VALUES(podpis_base64), podpis_base64),
                data_zapisu = NOW()";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':nr' => $nrZamowienia,
        ':user' => $user,
        ':trasa' => $nazwaTrasy,
        ':data' => $dataDostawy,
        ':komentarz' => $komentarz,
        ':podpis' => $podpisEncrypted,
        ':zdjecia' => json_encode($finalPaths)
    ]);

    echo json_encode(['status' => 'success']);

} catch (Exception $e) {
    http_response_code(500);
    loguj("BŁĄD: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'error' => $e->getMessage()]);
}
?>